<?php

namespace App\Http\Integrations\GetOnlinetrader\Requests\Membership;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class LessonsRequest extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::GET;

    public function __construct(protected readonly string $lesson_id)
    {
    }
    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return '/lesson';
    }
    protected function defaultQuery(): array
    {
        return [
            'lessonId' => $this->lesson_id,
        ];
    }
}
