<?php

namespace App\Livewire\Admin\Membership;

use App\Models\Settings;
use App\Exceptions\MembershipException;
use App\Services\MembershipService;
use Livewire\Attributes\Layout;
use Livewire\Component;

#[Layout('layouts.admin')]
class Courses extends Component
{
    public $courses;
    public $page;
    public $nextPageUrl;
    public $previousPageUrl;
    public $categories;

    // Initialize component
    public function mount(MembershipService $membership, int $page = 1): void
    {
        // Check if the membership module is enabled
        $settings = Settings::select('modules')->find(1);
        abort_if($settings->modules['membership'] !== 'true', 404);

        $this->page = $page;

        try {
            // Fetch categories
            $this->categories = $membership->categories();
        } catch (\Exception $e) {
            session()->flash('error', $e->getMessage());
        }
    }

   
    public function render(MembershipService $membership)
    {
    try {
        
        $response = $membership->courses($this->page);

        // Assign data with lesson counts
        $this->courses = $response['data'] ?? [];
        $this->nextPageUrl = $response['next_page_url'] ?? null;
        $this->previousPageUrl = $response['prev_page_url'] ?? null;
    } catch (\Exception $e) {
        session()->flash('error', $e->getMessage());
    }

    return view('livewire.admin.membership.courses');
    }


    // Go to next page
    public function nextPage(MembershipService $membership): void
    {
        if ($this->nextPageUrl) {
            $this->page++;
            $this->render($membership);
        }
    }

    // Go to previous page
    public function previousPage(MembershipService $membership): void
    {
        if ($this->previousPageUrl) {
            $this->page--;
            $this->render($membership);
        }
    }
}
