<?php

namespace App\Livewire\User\Onboarding;

use App\Models\User;
use App\Models\Settings;
use App\Services\Website;
use Livewire\Component;

class Welcome extends Component
{
    public $currentStep = 1;
    public $totalSteps = 5;
    public $hasSeenOnboarding;

    public function mount()
    {
        $user = auth()->user();
        if ($user->has_seen_onboarding == 1) {
            return redirect()->route('user.dashboard');
        }
    }

    public function nextStep()
    {
        if ($this->currentStep < $this->totalSteps) {
            $this->currentStep++;
        }
    }

    public function previousStep()
    {
        if ($this->currentStep > 1) {
            $this->currentStep--;
        }
    }

    public function finish()
    {
        if ($this->currentStep < $this->totalSteps) {
            $this->currentStep++;
        } else {
            $user = auth()->user();
            $user->has_seen_onboarding = true;
            $user->save();
            
            return redirect()->route('user.dashboard');
        }
    }

    public function render()
    {
        $settings = Settings::select(['theme', 'site_name'])->find(1);
        return view('livewire.user.onboarding.welcome')
            ->extends("layouts.welcome")
            ->title('Welcome to ' . $settings->site_name);
    }
}