<x-guest-layout>
   <x-slot:title>{{ __('t.sign_in') }}</x-slot:title>
   
   <div class="min-h-screen flex flex-col items-center justify-center">
       <div class="w-full max-w-md">
           {{-- Mobile Logo --}}
           <div class="lg:hidden flex flex-col items-center gap-4 mb-8">
               <img 
                   alt="Logo" 
                   src="{{ asset($settings->logo) }}"
                   class="w-[250px] h-auto animate-float" 
               />
               <div class="flex items-center gap-2 text-sm">
                   <div class="w-2 h-2 rounded-full bg-theme-primary animate-pulse"></div>
                   <span class="text-gray-400">{{ __('t.trading_platform') }}</span>
               </div>
           </div>

           <x-language-switcher />
           
           <div class="bg-theme-secondary rounded-2xl p-6 mt-6 border border-gray-800/50">
               {{-- Header --}}
               <div class="text-center mb-8 space-y-4">
                   <div class="bg-gradient-to-b from-theme-primary/10 to-transparent w-20 h-20 rounded-2xl flex items-center justify-center mx-auto">
                       <i class="fas fa-user-shield text-theme-primary text-3xl"></i>
                   </div>
                   <div>
                       <h1 class="text-2xl font-medium bg-gradient-to-r from-white to-gray-300 bg-clip-text text-transparent">
                           {{ __('t.welcome_back') }}
                       </h1>
                       <p class="text-gray-400 mt-2">{{ __('t.sign_in_con') }}</p>
                   </div>
               </div>

               @session('status')
                   <div class="bg-theme-primary/10 border border-theme-primary/20 text-theme-primary p-4 rounded-xl mb-6" role="alert">
                       {{ $value }}
                   </div>
               @endsession

               @if ($settings->enable_social_login)
                   @include('auth.social')
               @endif

               <form method="POST" action="{{ route('login') }}" class="space-y-6">
                   @csrf

                   {{-- Email Field --}}
                 <div class="space-y-2">
    <label class="text-sm text-gray-400">{{ __('t.email_username') }}</label>
    <div class="relative">
        <div class="absolute left-4 top-1/2 -translate-y-1/2">
            <i class="fas fa-envelope text-gray-400"></i>
        </div>
        <x-form.input 
            type="text" 
            placeholder="{{ __('t.email_placeholder') }}"
            value="{{ old('email') }}"
            name="email" 
            required 
            autofocus 
            autocomplete="username"
            class="w-full bg-theme-tertiary border border-gray-800/50 rounded-xl pl-12 pr-4 py-3.5 text-gray-100 focus:outline-none focus:border-theme-primary transition-colors" />
    </div>
    <div>
        @error('email')
            <small class="text-xs text-danger fs-6">{{ $message }}</small>
        @enderror
    </div>

                   </div>

                   {{-- Password Field --}}
                   <div class="space-y-2">
                       <label class="text-sm text-gray-400">{{ __('t.password') }}</label>
                       <div class="relative">
                           <div class="absolute left-4 top-1/2 -translate-y-1/2">
                               <i class="fas fa-lock text-gray-400"></i>
                           </div>
                           <x-form.input 
                               type="password" 
                               placeholder="••••••••"
                               name="password" 
                               required
                               autocomplete="current-password" 
                               wire:model='password'
                               class="w-full bg-theme-tertiary border border-gray-800/50 rounded-xl pl-12 pr-12 py-3.5 text-gray-100 focus:outline-none focus:border-theme-primary transition-colors" />
                           <button type="button"
                               class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-theme-primary transition-colors p-1"
                               data-kt-password-meter-control="visibility">
                               <i class="fas fa-eye"></i>
                               <i class="fas fa-eye-slash hidden"></i>
                           </button>
                       </div>
                   </div>

                   {{-- Remember & Forgot --}}
                   <div class="flex items-center justify-between pt-2">
                       <label class="inline-flex items-center">
                           <x-checkbox 
                               type="checkbox" 
                               name="remember"
                               class="rounded-lg border-gray-800/50 text-theme-primary focus:ring-theme-primary/20" />
                           <span class="ml-2 text-sm text-gray-400">
                               {{ __('t.remember_me') }}
                           </span>
                       </label>

                       @if (Route::has('password.request'))
                           <x-ui.link 
                               href="{{ route('password.request') }}" 
                               label="{{ __('t.forgot_password') }}"
                               class="text-sm text-theme-primary hover:brightness-110 transition-all" />
                       @endif
                   </div>

                   {{-- Submit Button --}}
                   <button type="submit"
                       class="w-full bg-gradient-to-r from-theme-primary to-theme-primary/80 text-white font-medium px-6 py-3.5 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-2 relative mt-8">
                       <span class="indicator-label flex items-center gap-2">
                           <i class="fas fa-right-to-bracket"></i>
                           {{ __('t.sign_in') }}
                       </span>
                       <span class="indicator-progress hidden">
                           {{ __('t.please_wait') }}
                           <i class="fas fa-spinner fa-spin ml-2"></i>
                       </span>
                   </button>


                   {{-- Sign Up Link --}}
                   <div class="text-center text-gray-400 border-t border-gray-800/50 pt-6">
                       <span class="text-sm">{{ __('t.not_a_member') }}</span>
                       <x-ui.link 
                           href="{{ url('/register') }}" 
                           label="{{ __('t.sign_up') }}"
                           class="text-theme-primary hover:brightness-110 transition-all ml-1 font-medium" />
                   </div>
               </form>
           </div>

           {{-- Security Badges --}}
           <div class="flex justify-center gap-6 mt-8">
               <div class="w-3 h-3 rounded-full bg-theme-primary/20 animate-pulse"></div>
               <div class="w-3 h-3 rounded-full bg-theme-primary/20 animate-pulse" style="animation-delay: 0.2s"></div>
               <div class="w-3 h-3 rounded-full bg-theme-primary/20 animate-pulse" style="animation-delay: 0.4s"></div>
           </div>
       </div>
   </div>
</x-guest-layout>

<script>
   document.addEventListener('DOMContentLoaded', function() {
       // Password visibility toggle
       document.querySelector('[data-kt-password-meter-control="visibility"]').addEventListener('click', function() {
           const passwordInput = document.querySelector('input[name="password"]');
           const eyeIcon = this.querySelector('.fa-eye');
           const eyeOffIcon = this.querySelector('.fa-eye-slash');

           if (passwordInput.type === 'password') {
               passwordInput.type = 'text';
               eyeIcon.classList.add('hidden');
               eyeOffIcon.classList.remove('hidden');
           } else {
               passwordInput.type = 'password';
               eyeIcon.classList.remove('hidden');
               eyeOffIcon.classList.add('hidden');
           }
       });

       // Form submission handling
       document.querySelector('form').addEventListener('submit', function() {
           const button = this.querySelector('button[type="submit"]');
           const label = button.querySelector('.indicator-label');
           const progress = button.querySelector('.indicator-progress');

           label.classList.add('hidden');
           progress.classList.remove('hidden');
       });
   });
</script>






