<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="shortcut icon" href="{{ asset($settings->favicon) }}" />
    <title>{{ $settings->site_name }} - {{ __('t.verify_your_email') }}</title>
    <meta name="description" content="{{ $settings->description }}" />
    <meta name="keywords" content="{{ $settings->keywords }}" />
    
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" />
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['Inter', 'sans-serif'] },
                    colors: {
                        background: '#0A0714',
                        primary: 'var(--color-primary)',
                        secondary: 'var(--color-tertiary)',
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-background text-gray-100 min-h-screen flex items-center justify-center p-6">
    <div class="w-full max-w-lg">
        <div class="bg-theme-secondary rounded-2xl p-8 shadow-xl">
            {{-- Header --}}
            <div class="flex justify-center">
                <div class="bg-theme-primary/5 rounded-2xl p-8 mb-8">
                    <img 
                        alt="Logo" 
                        src="{{ asset($settings->logo) }}"
                        class="h-12" />
                </div>
            </div>

            {{-- Status Alert --}}
            @if (session('status') == 'verification-link-sent')
                <div class="bg-theme-primary/10 text-theme-primary p-4 rounded-xl mb-8 flex items-center gap-3">
                    <i data-lucide="check-circle" class="w-5 h-5 flex-shrink-0"></i>
                    <p>{{ __('t.verification_link_sent') }}</p>
                </div>
            @endif

            <div class="text-center space-y-8">
                {{-- Icon --}}
                <div class="bg-theme-primary/10 w-20 h-20 rounded-2xl flex items-center justify-center mx-auto">
                    <i data-lucide="mail-check" class="w-10 h-10 text-theme-primary"></i>
                </div>

                {{-- Title & Description --}}
                <div class="space-y-3">
                    <h1 class="text-2xl font-medium">{{ __('t.verify_your_email') }}</h1>
                    <p class="text-gray-400 max-w-md mx-auto">
                        {{ __('t.check_email_inbox') }}
                    </p>
                </div>

                {{-- Action Buttons --}}
                <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                    <form method="POST" action="{{ route('verification.send') }}" class="w-full sm:w-auto">
                        @csrf
                        <button type="submit"
                            class="w-full sm:w-auto bg-theme-primary text-white font-medium px-8 py-3 rounded-xl hover:bg-[#1D4ED8] transition-colors flex items-center justify-center gap-3">
                            <i data-lucide="mail" class="w-5 h-5"></i>
                            <span>{{ __('t.resend_email') }}</span>
                        </button>
                    </form>

                    <form method="POST" action="{{ route('logout') }}" class="w-full sm:w-auto">
                        @csrf
                        <button type="submit"
                            class="w-full sm:w-auto bg-theme-tertiary text-gray-300 font-medium px-8 py-3 rounded-xl hover:bg-theme-quaternary transition-colors flex items-center justify-center gap-3">
                            <i data-lucide="log-out" class="w-5 h-5"></i>
                            <span>{{ __('t.log_out') }}</span>
                        </button>
                    </form>
                </div>

                {{-- Illustration --}}
                <div class="mt-12 bg-theme-tertiary rounded-2xl p-6">
                    <img 
                        src="{{ asset('themes/default/media/auth/verify-email.png') }}"
                        class="max-w-full h-auto max-h-[250px] mx-auto"
                        alt="{{ __('t.verify_email_illustration_alt') }}" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            lucide.createIcons();

            window.locale = '{{ app()->getLocale() }}';
            window.translations = @json(__('investment'));
        });
    </script>
</body>
</html>






