<div class="max-w-4xl mx-auto py-2 px-4">
    <x-danger-alert />
    <x-success-alert />

    {{-- Main Deposit Form Card --}}
    <div class="bg-theme-secondary rounded-2xl" x-data="{ method: @entangle('method') }">
        {{-- Header Section --}}
        <div class="p-6 border-b border-gray-800/50">
            <div class="flex items-center justify-between">
                <h2 class="text-xl font-medium">{{ __('t.make_deposit') }}</h2>
                <a href="{{ route('user.transactions.deposit') }}" 
                    class="flex items-center gap-2 text-sm text-gray-400 hover:text-theme-primary transition-colors group">
                    <i data-lucide="history" class="w-4 h-4"></i>
                    <span>{{ __('t.transaction_history') }}</span>
                    <i data-lucide="arrow-right" class="w-4 h-4 group-hover:translate-x-1 transition-transform"></i>
                </a>
            </div>
        </div>
        
        <form wire:submit='submitPayment' class="p-6 space-y-8">
            {{-- Amount Input Section --}}
            <div class="space-y-2">
                <label class="block text-sm text-gray-400">{{ __('t.amount_deposit') }}</label>
                <div class="bg-theme-tertiary rounded-xl p-1">
                    <div class="relative">
                        <div class="absolute left-4 top-1/2 -translate-y-1/2 text-xl font-medium text-theme-primary">
                            $
                        </div>
                        <input 
                            type="number" 
                            wire:model='amount'
                            min="50"
                            placeholder="{{ __('t.enter_amount') }}"
                            class="w-full bg-transparent pl-8 pr-4 py-4 text-lg font-medium focus:outline-none placeholder-gray-600"
                            required
                        >
                        <!-- <div class="absolute right-4 top-1/2 -translate-y-1/2 text-sm px-2 py-1 bg-theme-primary/10 text-theme-primary rounded-lg">
                            {{ __('t.min_amount') }} {{ Number::currency($settings->minamt, $settings->s_currency) }}
                        </div> -->
                    </div>
                </div>
            </div>

           {{-- Payment Methods Section --}}
<div class="space-y-4">
    <label class="block text-sm text-gray-400">{{ __('t.select_payment') }}</label>
    <div class="grid gap-4 sm:grid-cols-2">
        @forelse($methods as $paymentMethod)
            <button type="button" 
                wire:click="$set('method', '{{ $paymentMethod->name }}')"
                class="group relative"
            >
                <div class="bg-theme-tertiary rounded-xl border-2 transition-all duration-300 overflow-hidden"
                    :class="{ 
                        'border-theme-primary shadow-lg shadow-[#2563EB]/10 scale-[1.02]': '{{ $method }}' === '{{ $paymentMethod->name }}',
                        'border-transparent group-hover:border-theme-primary/30 group-hover:scale-[1.01]': '{{ $method }}' !== '{{ $paymentMethod->name }}'
                    }"
                >
                    {{-- Top Section with Icon and Name --}}
                    <div class="p-5 relative">
                        <div class="flex items-center gap-4">
                            {{-- Icon Container with Glow Effect --}}
                            <div class="relative">
                                <div class="absolute inset-0 bg-theme-primary/20 blur-xl rounded-full transition-opacity"
                                    :class="{ 
                                        'opacity-100': '{{ $method }}' === '{{ $paymentMethod->name }}',
                                        'opacity-0 group-hover:opacity-50': '{{ $method }}' !== '{{ $paymentMethod->name }}'
                                    }"></div>
                                <div class="w-12 h-12 flex items-center justify-center bg-gray-800/50 rounded-xl relative">
                                    @if(!empty($paymentMethod->img_url))
                                        <img src="{{ $paymentMethod->img_url }}" alt="" class="w-8 h-8">
                                    @endif
                                </div>
                            </div>
                            
                            {{-- Method Name and Processing Info --}}
                            <div class="flex-1 text-left">
                                <p class="font-medium text-lg">{{ $paymentMethod->name }}</p>
                                <div class="flex items-center gap-2 text-sm text-gray-400">
                                    <i class="fas fa-bolt w-4 h-4"></i>
                                    {{ __('t.instant_processing') }}
                                </div>
                            </div>

                            {{-- Selection Indicator with Animation --}}
                            <div class="w-6 h-6 rounded-full border-2 transition-all duration-300 flex items-center justify-center"
                                :class="{ 
                                    'border-theme-primary bg-theme-primary/10 rotate-180': '{{ $method }}' === '{{ $paymentMethod->name }}',
                                    'border-gray-700': '{{ $method }}' !== '{{ $paymentMethod->name }}'
                                }">
                                <div class="w-3 h-3 rounded-full transition-transform duration-300"
                                    :class="{ 
                                        'bg-theme-primary scale-100': '{{ $method }}' === '{{ $paymentMethod->name }}',
                                        'scale-0': '{{ $method }}' !== '{{ $paymentMethod->name }}'
                                    }">
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Bottom Section with Exchange Rate --}}
                    @if(in_array($paymentMethod->name, ['Bitcoin', 'Ethereum', 'USDT', 'Litecoin']))
                        <div class="border-t border-gray-800/50 p-4 bg-gradient-to-r"
                            :class="{ 
                                'from-[#2563EB]/5 to-transparent': '{{ $method }}' === '{{ $paymentMethod->name }}',
                                'from-gray-800/20 to-transparent': '{{ $method }}' !== '{{ $paymentMethod->name }}'
                            }">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-exchange-alt w-4 h-4 text-gray-400"></i>
                                    <span class="text-sm text-gray-400">1 USD ≈</span>
                                </div>
                                <div class="text-right">
                                    @if($loading)
                                        <div class="flex items-center gap-2">
                                            <i class="fas fa-spinner fa-spin w-4 h-4 text-gray-400"></i>
                                            <span class="text-sm text-gray-400">{{ __('t.loading_rates') }}</span>
                                        </div>
                                    @elseif($error)
                                        <button wire:click="refreshRates" class="text-sm text-red-400 hover:text-red-300">
                                            {{ __('t.error_loading_rate') }} • {{ __('t.retry') }}
                                        </button>
                                    @else
                                        <span class="font-mono text-sm"
                                            :class="{ 
                                                'text-theme-primary': '{{ $method }}' === '{{ $paymentMethod->name }}',
                                                'text-gray-400': '{{ $method }}' !== '{{ $paymentMethod->name }}'
                                            }">
                                            {{ number_format($cryptoRates[$paymentMethod->name] ?? 0, 8) }} {{ $paymentMethod->name }}
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </button>
        @empty
            <div class="sm:col-span-2 bg-theme-tertiary p-8 rounded-xl text-center">
                <div class="w-16 h-16 mx-auto mb-4 rounded-full bg-gray-800/50 flex items-center justify-center">
                    <i class="fas fa-exclamation-circle w-8 h-8 text-gray-400"></i>
                </div>
                <h3 class="text-lg font-medium mb-2">{{ __('t.no_payment_methods') }}</h3>
                <p class="text-gray-400">{{ __('t.payment_methods_later') }}</p>
            </div>
        @endforelse
    </div>
</div>

            {{-- Submit Button Section --}}
            @if(count($methods) > 0)
                <div class="pt-4">
                    <button type="submit" 
                        class="w-full bg-gradient-theme-primary text-black font-medium px-8 py-4 rounded-xl hover:brightness-110 transition-all duration-200 inline-flex items-center justify-center gap-3 disabled:opacity-50 disabled:cursor-not-allowed disabled:hover:brightness-100">
                        <div wire:loading wire:target='submitPayment'>
                             <i class="fas fa-spinner fa-spin fa-lg text-black"></i>
                        </div>
                        <span wire:loading.remove wire:target='submitPayment' class="text-lg">
                            {{ __('t.continue_payment') }}
                        </span>
                        <i data-lucide="arrow-right" wire:loading.remove wire:target='submitPayment' class="w-5 h-5"></i>
                    </button>
                </div>
            @endif
        </form>
    </div>

    {{-- Stats Card --}}
    <div class="bg-theme-secondary rounded-2xl mt-6 mb-10 md:mb-1">
        <div class="flex flex-wrap">
            <div class="w-full md:w-1/2 p-6">
                <div class="flex items-center gap-4">
                    <div class="w-14 h-14 flex items-center justify-center bg-theme-tertiary rounded-xl">
                        <i class="fas fa-history fa-2x text-theme-primary"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-medium">{{ __('t.recent_activity') }}</h3>
                        <a href="{{ route('user.transactions.deposit') }}" 
                            class="text-theme-primary hover:underline">
                            {{ __('t.view_all_transactions') }} →
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    lucide.createIcons();
</script>



