<div class="p-2 space-y-6">
    {{-- Breadcrumbs 
    <div class="flex items-center text-sm">
        <a href="{{ route('user.dashboard') }}" class="text-gray-400 hover:text-theme-primary transition-colors">{{ __('t.dashboard') }}</a>
        <i class="fas fa-chevron-right w-4 h-4 mx-2 text-gray-400"></i>
        <span class="text-gray-400">{{ __('t.trade_signal') }}</span>
    </div> --}}

    <x-danger-alert />
    <x-success-alert />

    <div class="bg-theme-secondary rounded-2xl">
        <div class="p-6">
            @if (!$subscription)
                {{-- No Subscription State --}}
                <div class="py-16 text-center">
                    <div class="w-16 h-16 mx-auto mb-6 bg-theme-tertiary rounded-2xl flex items-center justify-center">
                        <i class="fas fa-signal text-theme-primary text-2xl"></i>
                    </div>
                    <h3 class="text-xl font-medium mb-2">{{ __('t.no_active_subscription') }}</h3>
                    <p class="text-gray-400 mb-6">{{ __('t.subscribe_premium_signals') }}</p>
                    <button type="button" 
                        class="inline-flex items-center gap-2 bg-gradient-theme-primary text-black px-6 py-3 rounded-xl hover:brightness-110 transition-all font-medium"
                        data-toggle="modal"
                        data-target="#exampleModal">
                        <i class="fas fa-plus"></i>
                        {{ __('t.subscribe_now') }}
                    </button>
                </div>
            @else
                @if ($subscription['status'] == 'banned')
                    {{-- Banned State --}}
                    <div class="py-16 text-center">
                        <div class="w-16 h-16 mx-auto mb-6 bg-red-500/10 rounded-2xl flex items-center justify-center">
                            <i class="fas fa-ban text-red-500 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-medium mb-2">{{ __('t.subscription_banned') }}</h3>
                        <p class="text-gray-400 mb-6">{{ __('t.contact_support_assistance') }}</p>
                        <a href="{{ route('user.contactsupport') }}"
                            @if ($settings->spa_mode) wire:navigate @endif
                            class="inline-flex items-center gap-2 bg-theme-primary/10 text-theme-primary px-6 py-3 rounded-xl hover:bg-theme-primary/20 transition-colors">
                            <i class="fas fa-headset"></i>
                            {{ __('t.contact_support_button') }}
                        </a>
                    </div>
                @else
                    {{-- Active Subscription State --}}
                    <div class="grid lg:grid-cols-3 gap-6">
                        {{-- Subscription Info Card --}}
                        <div class="lg:col-span-2">
                            <div class="bg-theme-tertiary rounded-xl p-6">
                                <div class="flex items-center gap-4 mb-6">
                                    <div class="w-12 h-12 flex items-center justify-center bg-theme-primary/10 rounded-xl">
                                        <i class="fas fa-crown text-theme-primary"></i>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-medium">{{ __('t.subscription_type', ['subscription' => $subscription['subscription']]) }}</h3>
                                        <p class="text-2xl font-medium text-theme-primary">
                                            {{ $settings->currency . $subscription['amount_paid'] }}
                                        </p>
                                    </div>
                                </div>

                                <div class="space-y-4">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 flex items-center justify-center bg-red-500/10 rounded-lg">
                                            <i class="fas fa-clock text-red-500"></i>
                                        </div>
                                        <div>
                                            <p class="text-sm text-red-500">{{ __('t.expires_on') }}</p>
                                            <p class="text-gray-300">
                                                {{ \Carbon\Carbon::parse($subscription['expired_at'])->inUserTimezone()->toDayDateTimeString() }}
                                            </p>
                                        </div>
                                    </div>

                                    @if (now()->greaterThanOrEqualTo(\Carbon\Carbon::parse($subscription['reminded_at'])) ||
                                            now()->greaterThanOrEqualTo(\Carbon\Carbon::parse($subscription['expired_at'])))
                                        @php
                                            if ($subscription['subscription'] == 'Monthly') {
                                                $fee = $set['signal_monthly_fee'];
                                            } elseif ($subscription['subscription'] == 'Quarterly') {
                                                $fee = $set['signal_quarterly_fee'];
                                            } else {
                                                $fee = $set['signal_yearly_fee'];
                                            }
                                        @endphp
                                        {{-- Add this at component level --}}
                                        <div x-data="{ showConfirm: false, fee: '{{ $fee }}' }">
                                            {{-- Button that triggers confirmation --}}
                                            <button type="button"
                                                @click="showConfirm = true"
                                                class="w-full bg-gradient-theme-primary text-black px-6 py-3 rounded-xl hover:brightness-110 transition-all font-medium inline-flex items-center justify-center gap-2">
                                                <i class="fas fa-sync-alt"></i>
                                                <span>{{ __('t.renew_subscription') }}</span>
                                            </button>

                                            {{-- Confirmation Modal --}}
                                            <template x-teleport="body">
                                                <div x-show="showConfirm" 
                                                    class="fixed inset-0 z-50 overflow-y-auto"
                                                    style="display: none;"
                                                    x-transition:enter="transition ease-out duration-300"
                                                    x-transition:enter-start="opacity-0"
                                                    x-transition:enter-end="opacity-100"
                                                    x-transition:leave="transition ease-in duration-200"
                                                    x-transition:leave-start="opacity-100"
                                                    x-transition:leave-end="opacity-0">
                                                    
                                                    {{-- Backdrop --}}
                                                    <div class="fixed inset-0 bg-black/50 backdrop-blur-sm"></div>

                                                    {{-- Modal Panel --}}
                                                    <div class="relative min-h-screen flex items-center justify-center p-4">
                                                        <div class="relative bg-theme-secondary rounded-2xl max-w-md w-full p-6"
                                                            x-transition:enter="transition ease-out duration-300"
                                                            x-transition:enter-start="opacity-0 translate-y-4"
                                                            x-transition:enter-end="opacity-100 translate-y-0"
                                                            x-transition:leave="transition ease-in duration-200"
                                                            x-transition:leave-start="opacity-100 translate-y-0"
                                                            x-transition:leave-end="opacity-0 translate-y-4">
                                                            
                                                            {{-- Icon --}}
                                                            <div class="w-12 h-12 mx-auto mb-4 bg-theme-primary/10 rounded-full flex items-center justify-center">
                                                                <i class="fas fa-credit-card text-theme-primary"></i>
                                                            </div>

                                                            {{-- Content --}}
                                                            <div class="text-center mb-6">
                                                                <h3 class="text-lg font-medium mb-2">{{ __('t.confirm_renewal') }}</h3>
                                                                <p class="text-gray-400">
                                                                    {{ __('t.renewal_message', ['currency' => $settings->currency, 'fee' => $fee]) }}
                                                                </p>
                                                            </div>

                                                            {{-- Actions --}}
                                                            <div class="flex gap-3">
                                                                <button type="button"
                                                                    @click="showConfirm = false"
                                                                    class="flex-1 px-4 py-2.5 border border-gray-800 rounded-xl text-gray-400 hover:bg-gray-800/50 transition-colors">
                                                                    {{ __('t.cancel') }}
                                                                </button>
                                                                <button type="button"
                                                                    @click="$wire.renew('{{ $fee }}'); showConfirm = false"
                                                                    class="flex-1 bg-gradient-theme-primary text-black font-medium px-4 py-2.5 rounded-xl hover:brightness-110 transition-all">
                                                                    {{ __('t.confirm') }}
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </template>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        {{-- Quick Stats Card --}}
                        <div class="lg:col-span-1">
                            <div class="bg-theme-tertiary rounded-xl p-6">
                                <h4 class="text-sm text-gray-400 mb-4">{{ __('t.signal_statistics') }}</h4>
                                <div class="space-y-4">
                                    <div class="flex justify-between items-center p-3 bg-theme-secondary rounded-lg">
                                        <div class="flex items-center gap-3">
                                            <div class="w-8 h-8 flex items-center justify-center bg-green-500/10 rounded-lg">
                                                <i class="fas fa-check text-green-500"></i>
                                            </div>
                                            <span class="text-sm">{{ __('t.success_rate') }}</span>
                                        </div>
                                        <span class="text-green-500">85%</span>
                                    </div>
                                    <div class="flex justify-between items-center p-3 bg-theme-secondary rounded-lg">
                                        <div class="flex items-center gap-3">
                                            <div class="w-8 h-8 flex items-center justify-center bg-theme-primary/10 rounded-lg">
                                                <i class="fas fa-signal text-theme-primary"></i>
                                            </div>
                                            <span class="text-sm">{{ __('t.active_signals') }}</span>
                                        </div>
                                        <span>{{ $signals->count() }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Signals Table Section --}}
                    <div class="mt-6">
                        <div class="bg-theme-tertiary rounded-xl">
                            <div class="p-6 border-b border-gray-800/50">
                                <div class="flex items-center justify-between">
                                    <h4 class="text-lg font-medium">{{ __('t.trade_signals') }}</h4>
                                    <div class="flex items-center gap-2 text-sm text-gray-400">
                                        <i class="fas fa-info-circle"></i>
                                        <span>{{ __('t.updated_every', ['hours' => 6]) }}</span>
                                    </div>
                                </div>
                            </div>

                            <div class="p-6">
                                <div class="overflow-x-auto">
                                    <table class="w-full">
                                        <thead>
                                            <tr class="text-left text-sm text-gray-400 border-b border-gray-800/50">
                                                <th class="pb-4 font-medium">{{ __('t.order_type') }}</th>
                                                <th class="pb-4 font-medium">{{ __('t.currency') }}</th>
                                                <th class="pb-4 font-medium">{{ __('t.price') }}</th>
                                                <th class="pb-4 font-medium hidden lg:table-cell">{{ __('t.take_profit_1') }}</th>
                                                <th class="pb-4 font-medium hidden lg:table-cell">{{ __('t.take_profit_2') }}</th>
                                                <th class="pb-4 font-medium hidden lg:table-cell">{{ __('t.stop_loss') }}</th>
                                                <th class="pb-4 font-medium">{{ __('t.result') }}</th>
                                                <th class="pb-4 font-medium hidden md:table-cell">{{ __('t.date') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody class="divide-y divide-gray-800/50">
                                            @forelse ($signals as $signal)
                                                <tr class="group hover:bg-theme-secondary transition-colors">
                                                    <td class="py-4">
                                                        <span class="inline-flex items-center gap-2">
                                                            <i class="fas fa-arrow-{{ $signal['direction'] == 'Buy' ? 'up text-green-500' : 'down text-red-500' }}"></i>
                                                            {{ __('t.' . strtolower($signal['direction'])) }}
                                                        </span>
                                                    </td>
                                                    <td class="py-4">{{ $signal['pair'] }}</td>
                                                    <td class="py-4 font-medium">{{ $signal['price'] }}</td>
                                                    <td class="py-4 hidden lg:table-cell">{{ $signal['tp1'] }}</td>
                                                    <td class="py-4 hidden lg:table-cell">{{ $signal['tp2'] ? $signal['tp2'] : '-' }}</td>
                                                    <td class="py-4 hidden lg:table-cell">{{ $signal['sl1'] }}</td>
                                                    <td class="py-4">
                                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                                            {{ $signal['result'] == __('t.take_profit') ? 'bg-green-500/10 text-green-500' : 
                                                               ($signal['result'] == __('t.stop_loss') ? 'bg-red-500/10 text-red-500' : 
                                                               'bg-gray-500/10 text-gray-400') }}">
                                                            {{ $signal['result'] ? __('t.' . strtolower(str_replace(' ', '_', $signal['result']))) : __('t.pending') }}
                                                        </span>
                                                    </td>
                                                    <td class="py-4 hidden md:table-cell text-sm text-gray-400">
                                                        {{ \Carbon\Carbon::parse($signal['created_at'])->inUserTimezone()->format('d M Y') }}
                                                    </td>
                                                </tr>
                                                {{-- Mobile Expansion Row --}}
                                                <tr class="lg:hidden">
                                                    <td colspan="8" class="py-4 px-6 bg-theme-secondary/50">
                                                        <div class="space-y-2 text-sm">
                                                            <div class="flex justify-between">
                                                                <span class="text-gray-400">{{ __('t.take_profit_1') }}:</span>
                                                                <span>{{ $signal['tp1'] }}</span>
                                                            </div>
                                                            <div class="flex justify-between">
                                                                <span class="text-gray-400">{{ __('t.take_profit_2') }}:</span>
                                                                <span>{{ $signal['tp2'] ? $signal['tp2'] : '-' }}</span>
                                                            </div>
                                                            <div class="flex justify-between">
                                                                <span class="text-gray-400">{{ __('t.stop_loss') }}:</span>
                                                                <span>{{ $signal['sl1'] }}</span>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="8" class="py-8">
                                                        <div class="text-center">
                                                            <div class="w-12 h-12 mx-auto mb-4 bg-theme-secondary rounded-xl flex items-center justify-center">
                                                                <i class="fas fa-chart-line text-gray-400"></i>
                                                            </div>
                                                            <p class="text-gray-400">{{ __('t.no_signals_available') }}</p>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                                @include('components.pagination', ['route' => 'user.tradeSignals'])
                            </div>
                        </div>
                    </div>
                @endif
            @endif
        </div>
    </div>

    {{-- Subscribe Modal --}}
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content bg-theme-secondary border border-gray-800/50 rounded-xl">
                <div class="p-6 border-b border-gray-800/50">
                    <h5 class="text-lg font-medium">{{ __('t.choose_subscription_plan') }}</h5>
                </div>
                <div class="p-6">
                    <livewire:user.trade-signal.subscribe lazy />
                </div>
            </div>
        </div>
    </div>
</div>



