<?php

use App\Http\Controllers\CronController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\SetupController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ChatController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Setup routes (for initial installation)
Route::get('/setup', [SetupController::class, 'index'])->name('setup.index');

// Temporary test route to check error display
Route::get('/test-error', function() {
    throw new Exception('This is a test error - if you can see this detailed message, error display is working!');
});
Route::post('/setup/run', [SetupController::class, 'setup'])->name('setup.run');
Route::get('/setup/reset', [SetupController::class, 'reset'])->name('setup.reset');

// Include separate route files for admin and user
require __DIR__ . '/admin/web.php';
require __DIR__ . '/user/web.php';

// HTTP Cron endpoints (protected by secret token)
// See HTTP_CRON_SETUP_GUIDE.md for setup instructions
Route::prefix('cron')->group(function () {
    Route::get('/scheduler', [CronController::class, 'runScheduler'])->name('cron.scheduler');
    Route::get('/queue', [CronController::class, 'runQueue'])->name('cron.queue');
    Route::get('/health', [CronController::class, 'healthCheck'])->name('cron.health');
});

// Legacy cron route (deprecated - use /cron/scheduler instead)
Route::get('/cron', function () {
    Artisan::call('schedule:run');
});

Route::middleware(['auth'])->group(function () {
    Route::post('/chat/update-status', [ChatController::class, 'updateStatus']);
    Route::get('/chat/messages', [ChatController::class, 'getUserMessages']);
    Route::post('/chat/send', [ChatController::class, 'sendUserMessage']);
	Route::post('/chat/end', [ChatController::class, 'endChat']);
    Route::post('/chat/mark-read', [ChatController::class, 'markAsRead']);
    Route::get('/chat/unread-count', [ChatController::class, 'getUnreadCount']);
	Route::post('/chat/typing', [ChatController::class, 'typing']);
});

// Language switch route
Route::get('language/{locale}', [LanguageController::class, 'switchLang'])
    ->name('language.switch');

// Static routes
Route::get('/', function () {
    $plans = \App\Models\Plan::where('status', 'active')->orderBy('min_price')->get();
    return view('home', compact('plans')); 
})->name('home');

Route::get('/about', function () {
    return view('about');
})->name('about');

Route::get('/markets', function () {
    return view('markets'); 
})->name('markets');

Route::get('/contact', function () {
    return view('contact');
})->name('contact');

Route::get('/faq', function () {
    return view('faq');
})->name('faq');

Route::get('/mkts', function () {
    return view('mkts');
})->name('mkts');

Route::get('/services-d8', function () {
    return view('services-d8');
})->name('services-d8');

Route::get('/pricing', function () {
    return view ('pricing');
})->name('pricing');

Route::get('/services', function () {
    return view ('services');
})->name('services');

Route::get('/services-d5', function () {
    return view('services-d5');
})->name('services-d5');

Route::get('/services-d9', function () {
    return view ('services-d9');
})->name('services-d9');

Route::get('/services-d6', function () {
    return view ('services-d6');
})->name('services-d6');

Route::get('/services-d3', function () {
    return view ('services-d3');
})->name('services-d3');

Route::get('/services-d1', function () {
    return view ('services-d1');
})->name('services-d1');

Route::get('/services-d2', function () {
    return view ('services-d2');
})->name('services-d2');

Route::get('/services-d4', function () {
    return view ('services-d4');
})->name('services-d4');

Route::get('/services-d7', function () {
    return view ('services-d7');
})->name('services-d7');

Route::get('/services-d10', function () {
    return view ('services-d10');
})->name('services-d10');

Route::get('/buy-btc', function () {
    return view ('buy-btc');
})->name('buy-btc');

// Dynamic CSS route for theme colors
Route::get('/css/theme-colors.css', function () {
    $themeService = new \App\Services\ThemeColorService();
    $css = $themeService->generateCssVariables();
    
    return response($css)
        ->header('Content-Type', 'text/css')
        ->header('Cache-Control', 'public, max-age=3600'); // Cache for 1 hour
})->name('theme-colors-css');

