<div class="flex flex-col items-center">
    <div class="w-24 h-24 mb-4">
        <img 
            src="<?php echo e($user->profile_photo_path ? asset('storage/' . $user->profile_photo_path) : asset('dash/images/avatar.svg')); ?>"
            alt="<?php echo e($user->name); ?>"
            class="w-full h-full rounded-xl object-cover border-2 border-gray-700">
    </div>

    <div class="space-y-2 text-center">
        <div class="font-medium"><?php echo e($user->name); ?></div>
        <div class="text-sm text-gray-400"><?php echo e($user->email); ?></div>

        <div class="relative">
            <button class="w-full bg-theme-primary text-black px-4 py-2 rounded-lg hover:bg-theme-primary-dark transition-colors flex items-center justify-center gap-2">
                <div wire:loading>
                    <i data-lucide="loader-2" class="w-5 h-5 animate-spin"></i>
                </div>
                <span wire:loading.remove><?php echo e(__('t.update_avatar')); ?></span>
            </button>
            <input type="file" 
                wire:model.live='avatar' 
                class="absolute inset-0 w-full h-full opacity-0 cursor-pointer">
        </div>

        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <p class="text-sm text-red-400"><?php echo e($message); ?></p>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
    </div>
</div>



<?php /**PATH /home/sbrbot/6figs.sbrbot.trading/resources/views/millage/account-settings/picture.blade.php ENDPATH**/ ?>