

<?php $__env->startSection('title', 'Trade'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6 mt-4 md:mt-1 md:mb-1 mb-[40px] bg-theme-tertiary">
    
    <div class="bg-theme-secondary border-b border-gray-800/50">
        <div class="w-full mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16 overflow-x-auto">
                
                <div class="relative">
                    <div id="currentPairDropdown" class="flex items-center cursor-pointer group">
                        <?php
                        $currentPairData = collect($pairs)->firstWhere('symbol', $pair);
                        ?>
                        <?php if($currentPairData): ?>
                        <img src="<?php echo e($currentPairData['icon']); ?>"
                            alt="<?php echo e($pair); ?> Icon"
                            class="w-8 h-8 mr-2 rounded-full">
                        <?php endif; ?>
                        <span class="text-lg font-medium mr-2"><?php echo e($pair); ?></span>
                        <i class="fas fa-chevron-down text-gray-400 group-hover:text-theme-primary transition-colors"></i>
                    </div>

                    <div id="pairSelectorModal" class="fixed inset-0 z-50 bg-black/50 items-center justify-center hidden">
                        <div class="bg-theme-secondary rounded-xl w-96 max-h-[70vh] overflow-y-auto">
                            <div class="p-4 border-b border-gray-800/50 flex justify-between items-center">
                                <h3 class="text-lg font-medium">Select Trading Pair</h3>
                                <button id="closePairSelector" class="text-gray-400 hover:text-white">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>

                            <div class="p-4">
                                <input
                                    type="text"
                                    id="pairSearchInput"
                                    placeholder="Search pairs..."
                                    class="w-full bg-theme-tertiary rounded-lg px-4 py-2 mb-4 text-white focus:outline-none focus:ring-2 focus:ring-theme-primary/50">

                                <div id="pairList">
                                    <?php $__currentLoopData = $pairs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pairData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div
                                        class="pair-option flex items-center p-3 hover:bg-theme-tertiary rounded-lg cursor-pointer transition-colors"
                                        data-pair="<?php echo e($pairData['symbol']); ?>">
                                        <img
                                            src="<?php echo e($pairData['icon']); ?>"
                                            alt="<?php echo e($pairData['name']); ?> Logo"
                                            class="w-8 h-8 mr-3 rounded-full">
                                        <div>
                                            <span class="font-medium"><?php echo e($pairData['name']); ?></span>
                                            <span class="text-sm text-gray-400 block"><?php echo e($pairData['symbol']); ?></span>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="flex items-center gap-6">
                    <div>
                        <span class="text-sm text-gray-400"><?php echo e($pair); ?> Price</span>
                        <div class="font-mono text-theme-primary font-medium" id="currentPrice">
                            $<?php echo e(number_format($currentPrice, 2)); ?>

                        </div>
                    </div>
                    <div>
                        <span class="text-sm text-gray-400">24h Change</span>
                        <div class="font-medium" id="priceChange">
                            <span class="<?php echo e($stats['changePercent'] >= 0 ? 'text-green-500' : 'text-red-500'); ?>">
                                <?php echo e($stats['changePercent'] >= 0 ? '+' : ''); ?><?php echo e(number_format($stats['changePercent'], 2)); ?>%
                            </span>
                        </div>
                    </div>
                </div>

                
                <div class="hidden md:flex items-center gap-6">
                    <div>
                        <span class="text-sm text-gray-400">24h Volume</span>
                        <div class="font-medium" id="volume"><?php echo e(number_format($stats['volume'], 2)); ?></div>
                    </div>
                    <div>
                        <span class="text-sm text-gray-400">24h High</span>
                        <div class="font-medium text-green-500" id="high">$<?php echo e(number_format($stats['high'], 2)); ?></div>
                    </div>
                    <div>
                        <span class="text-sm text-gray-400">24h Low</span>
                        <div class="font-medium text-red-500" id="low">$<?php echo e(number_format($stats['low'], 2)); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="w-full mx-auto px-2 sm:px-6 lg:px-8 py-6">
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
            
            <div class="lg:col-span-3 bg-theme-secondary rounded-xl p-4">
                
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center gap-2 overflow-x-auto pb-2">
                        <?php $__currentLoopData = $timeframes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tf => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button
                            type="button"
                            data-timeframe="<?php echo e($tf); ?>"
                            class="timeframe-btn px-3 py-1 rounded-lg text-sm transition-colors whitespace-nowrap <?php echo e($tf === '1' ? 'bg-theme-primary/10 text-theme-primary' : 'text-gray-400 hover:text-white'); ?>"
                            onclick="changeTimeframe('<?php echo e($tf); ?>')">
                            <?php echo e($label); ?>

                        </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    
                    <div class="hidden lg:flex items-center gap-4 text-sm">
                        <div class="px-3 py-1 bg-theme-tertiary rounded-lg">
                            <span class="text-gray-400">Win Rate:</span>
                            <span class="text-theme-primary"><?php echo e(number_format($user->win_rate ?? 0, 1)); ?>%</span>
                        </div>
                        <div class="px-3 py-1 bg-theme-tertiary rounded-lg">
                            <span class="text-gray-400">Total Profit:</span>
                            <span class="<?php echo e($totalProfit >= 0 ? 'text-green-500' : 'text-red-500'); ?>">
                                $<?php echo e(number_format($totalProfit, 2)); ?>

                            </span>
                        </div>
                    </div>
                </div>

                
                <div id="trading_chart" class="md:h-[620px] h-[500px] rounded-lg bg-theme-tertiary"></div>
            </div>

            
            <div class="bg-theme-secondary rounded-xl p-4">
                <div class="space-y-6">
                    
                    <div class="p-4 bg-theme-tertiary rounded-lg">
                        <span class="text-sm text-gray-400">Available Balance</span>
                        <div class="text-xl font-medium" id="walletBalance">
                            $<?php echo e(number_format($user->account_bal, 2)); ?>

                        </div>
                    </div>

                    
                    <div class="grid grid-cols-2 gap-3">
                        <button
                            type="button"
                            id="riseButton"
                            class="p-4 rounded-lg text-center transition-all bg-theme-tertiary text-gray-400 border-2 border-transparent hover:border-green-500/30"
                            data-type="Rise">
                            <i class="fas fa-arrow-up mb-2"></i>
                            <div class="font-medium">Rise</div>
                        </button>

                        <button
                            type="button"
                            id="fallButton"
                            class="p-4 rounded-lg text-center transition-all bg-theme-tertiary text-gray-400 border-2 border-transparent hover:border-red-500/30"
                            data-type="Fall">
                            <i class="fas fa-arrow-down mb-2"></i>
                            <div class="font-medium">Fall</div>
                        </button>
                    </div>

                    
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">Amount</label>
                        <div class="relative">
                            <input
                                type="number"
                                id="tradeAmount"
                                class="w-full bg-theme-tertiary border-2 border-gray-800 rounded-lg px-4 py-3 text-white focus:outline-none focus:border-theme-primary"
                                placeholder="Enter amount"
                                min="1">
                            <button
                                type="button"
                                id="maxAmount"
                                class="absolute right-4 top-1/2 -translate-y-1/2 text-theme-primary text-sm hover:underline">
                                MAX
                            </button>
                        </div>
                        <span id="amountError" class="text-sm text-red-500 mt-1 hidden"></span>
                    </div>

                    
                    <div class="grid grid-cols-4 gap-2">
                        <?php $__currentLoopData = [100, 250, 500, 1000]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quickAmount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button
                            type="button"
                            class="quick-amount px-2 py-1 bg-theme-tertiary rounded border border-gray-800 text-sm text-gray-400 hover:border-theme-primary hover:text-theme-primary transition-colors"
                            data-amount="<?php echo e($quickAmount); ?>">
                            $<?php echo e($quickAmount); ?>

                        </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">Duration</label>
                        <div class="grid grid-cols-3 gap-2">
                            <?php $__currentLoopData = ['1m', '5m', '15m', '30m', '1h', '4h', '1d']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button
                                type="button"
                                class="duration-btn px-3 py-2 rounded bg-theme-tertiary text-sm transition-colors text-gray-400 border-2 border-transparent hover:border-gray-800"
                                data-duration="<?php echo e($dur); ?>">
                                <?php echo e($dur); ?>

                            </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    
                    <div class="p-4 bg-theme-tertiary rounded-lg">
                        <div class="flex items-center justify-between mb-2">
                            <span class="text-sm text-gray-400">Profit</span>
                            <span class="text-theme-primary"><?php echo e($profit_percentage); ?>%</span>
                        </div>
                        <div class="text-sm text-gray-400" id="potentialReturn">
                            Potential Return: <span class="text-white">$0.00</span>
                        </div>
                    </div>

                    
                    <button
                        type="button"
                        id="placeTrade"
                        class="w-full bg-theme-primary text-black font-medium px-6 py-4 rounded-lg hover:brightness-110 transition-all disabled:opacity-50 disabled:cursor-not-allowed"
                        disabled>
                        <span id="tradeButtonText">Select Trade Type</span>
                        <span id="tradeButtonLoader" class="hidden">
                            <i class="fas fa-spinner fa-spin"></i> Processing...
                        </span>
                    </button>
                </div>
            </div>
        </div>

        
        <div class="mt-6 bg-theme-secondary rounded-xl overflow-hidden">
            <div class="p-4 border-b border-gray-800/50 flex items-center justify-between">
                <h2 class="text-lg font-medium">Recent Trades</h2>
                <a href="<?php echo e(route('user.trading.history')); ?>" class="text-theme-primary text-sm hover:underline">
                    View All
                </a>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-theme-tertiary">
                        <tr>
                            <th class="px-4 py-3 text-left text-sm font-medium text-gray-400">Time</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-gray-400">Pair</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-gray-400">Type</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-gray-400">Amount</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-gray-400">Result</th>
                            <th class="px-4 py-3 text-left text-sm font-medium text-gray-400">Profit/Loss</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-800/50">
                        <?php $__empty_1 = true; $__currentLoopData = $recentTrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-800/30 transition-colors">
                            <td class="px-4 py-3 text-sm">
                                <?php echo e($trade->created_at->diffForHumans()); ?>

                            </td>
                            <td class="px-4 py-3 text-sm">
                                <?php echo e($trade->pair); ?>

                            </td>
                            <td class="px-4 py-3">
                                <span class="px-2 py-1 rounded text-xs font-medium <?php echo e($trade->type === 'Rise' ? 'bg-green-500/10 text-green-500' : 'bg-red-500/10 text-red-500'); ?>">
                                    <?php echo e($trade->type); ?>

                                </span>
                            </td>
                            <td class="px-4 py-3 text-sm">
                                $<?php echo e(number_format($trade->amount, 2)); ?>

                            </td>
                            <td class="px-4 py-3 text-sm">
                                <?php if($trade->status === 'active'): ?>
                                <div class="flex items-center gap-1.5 text-yellow-500">
                                    <i class="fas fa-circle-notch fa-spin text-xs"></i>
                                    <span>Active</span>
                                </div>
                                <?php elseif($trade->status === 'completed'): ?>
                                <span class="text-<?php echo e($trade->result === 'win' ? 'green' : 'red'); ?>-500">
                                    <?php echo e(ucfirst($trade->result)); ?>

                                </span>
                                <?php else: ?>
                                <span class="text-gray-400"><?php echo e(ucfirst($trade->status)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3 text-sm">
                                <?php if($trade->status === 'completed'): ?>
                                <span class="font-medium <?php echo e($trade->profit_amount >= 0 ? 'text-green-500' : 'text-red-500'); ?>">
                                    <?php echo e($trade->profit_amount >= 0 ? '+' : ''); ?>$<?php echo e(number_format($trade->profit_amount, 2)); ?>

                                </span>
                                <?php else: ?>
                                <span class="text-gray-400">--</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="px-4 py-8 text-center text-gray-400">
                                <div class="flex flex-col items-center">
                                    <div class="w-16 h-16 mb-4 rounded-full bg-gray-800/50 flex items-center justify-center">
                                        <i class="fas fa-chart-line text-2xl"></i>
                                    </div>
                                    <p class="mb-2">No trades yet</p>
                                    <p class="text-sm text-gray-500 mb-4">Start your trading journey today</p>
                                    <a href="<?php echo e(route('user.trading.trade')); ?>" class="text-theme-primary hover:underline">
                                        Place Your First Trade
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


<div id="errorModal" class="fixed inset-0 z-50 overflow-y-auto hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 bg-gray-900 bg-opacity-75 transition-opacity" aria-hidden="true"></div>
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
        <div class="inline-block align-bottom bg-theme-secondary rounded-lg px-4 pt-5 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
            <div class="sm:flex sm:items-start">
                <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100 sm:mx-0 sm:h-10 sm:w-10">
                    <i class="fas fa-exclamation-triangle text-red-600"></i>
                </div>
                <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                    <h3 class="text-lg leading-6 font-medium" id="modal-title">Error</h3>
                    <div class="mt-2">
                        <p class="text-sm text-gray-400" id="errorMessage"></p>
                    </div>
                </div>
            </div>
            <div class="mt-5 sm:mt-4 sm:flex sm:flex-row-reverse">
                <button type="button" class="mt-3 w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-theme-primary text-base font-medium text-black hover:brightness-110 focus:outline-none sm:mt-0 sm:w-auto sm:text-sm" onclick="closeErrorModal()">
                    Close
                </button>
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const currentPairDropdown = document.getElementById('currentPairDropdown');
    const pairSelectorModal = document.getElementById('pairSelectorModal');
    const closePairSelector = document.getElementById('closePairSelector');
    const pairSearchInput = document.getElementById('pairSearchInput');
    const pairList = document.getElementById('pairList');
    const pairOptions = document.querySelectorAll('.pair-option');

    // Open pair selector
    currentPairDropdown.addEventListener('click', () => {
        pairSelectorModal.classList.remove('hidden');
        pairSelectorModal.classList.add('flex');
    });

    // Close pair selector
    closePairSelector.addEventListener('click', () => {
        pairSelectorModal.classList.add('hidden');
        pairSelectorModal.classList.remove('flex');
    });

    // Close modal when clicking outside
    pairSelectorModal.addEventListener('click', (e) => {
        if (e.target === pairSelectorModal) {
            pairSelectorModal.classList.add('hidden');
            pairSelectorModal.classList.remove('flex');
        }
    });

    // Search functionality
    pairSearchInput.addEventListener('input', (e) => {
        const searchTerm = e.target.value.toLowerCase();
        pairOptions.forEach(option => {
            const pairName = option.textContent.toLowerCase();
            option.style.display = pairName.includes(searchTerm) ? 'flex' : 'none';
        });
    });

    // Select pair
   pairOptions.forEach(option => {
    option.addEventListener('click', () => {
        const selectedPair = option.dataset.pair.replace('/', '');
        
        window.location.href = `/user/trading/trade/${selectedPair}`;
    });
});
});

document.addEventListener('DOMContentLoaded', function() {
    // Trading state
    const state = {
        tradeType: null,
        amount: 0,
        duration: '1m',
        symbol: '<?php echo e($symbol); ?>', // From controller
        currentPrice: <?php echo e($currentPrice); ?>,
        profitPercentage: <?php echo e($profit_percentage); ?>,
        ws: null,
        reconnectAttempts: 0,
        maxReconnectAttempts: 5,
        timeframe: '1' // Default timeframe added
    };

    // DOM Elements
    const elements = {
        currentPrice: document.getElementById('currentPrice'),
        priceChange: document.getElementById('priceChange'),
        volume: document.getElementById('volume'),
        high: document.getElementById('high'),
        low: document.getElementById('low'),
        tradeAmount: document.getElementById('tradeAmount'),
        walletBalance: document.getElementById('walletBalance'),
        riseButton: document.getElementById('riseButton'),
        fallButton: document.getElementById('fallButton'),
        placeTrade: document.getElementById('placeTrade'),
        tradeButtonText: document.getElementById('tradeButtonText'),
        tradeButtonLoader: document.getElementById('tradeButtonLoader'),
        potentialReturn: document.getElementById('potentialReturn'),
        amountError: document.getElementById('amountError'),
        recentTradesBody: document.getElementById('recentTradesBody'),
        timeframeButtons: document.querySelectorAll('.timeframe-btn')
    };

    // Initialize TradingView Chart Widget Variable
    let tradingViewWidget;

    // Initialize TradingView Chart with default timeframe
    function initTradingView(timeframe = '1') {
        if (tradingViewWidget) {
            tradingViewWidget.remove();
        }

        // Convert timeframe to TradingView format
        const interval = getTradeViewInterval(timeframe);

        tradingViewWidget = new TradingView.widget({
            "container_id": "trading_chart",
            "autosize": true,
            "symbol": `HUOBI:${state.symbol}`,
            "interval": interval,
            "timezone": "Etc/UTC",
            "theme": "dark",
            "style": "1",
            "locale": "en",
            "toolbar_bg": "var(--color-background-tertiary)",
            "enable_publishing": false,
            "hide_side_toolbar": true,
            "allow_symbol_change": false,
            "save_image": false,
            "backgroundColor": "var(--color-background-tertiary)",
            "gridColor": "#222222",
            "hide_volume": false,
            "enabled_features": ["use_localstorage_for_settings"],
            "disabled_features": [
                "header_symbol_search",
                "symbol_search_hot_key",
                "header_compare",
                "header_settings",
                "header_chart_type",
                "header_screenshot",
                "header_saveload"
            ],
            "overrides": {
                "mainSeriesProperties.candleStyle.upColor": "#26a69a",
                "mainSeriesProperties.candleStyle.downColor": "#ef5350",
                "mainSeriesProperties.candleStyle.borderUpColor": "#26a69a",
                "mainSeriesProperties.candleStyle.borderDownColor": "#ef5350",
                "mainSeriesProperties.candleStyle.wickUpColor": "#26a69a",
                "mainSeriesProperties.candleStyle.wickDownColor": "#ef5350",
                "paneProperties.background": "var(--color-background-tertiary)",
                "paneProperties.vertGridProperties.color": "#222222",
                "paneProperties.horzGridProperties.color": "#222222",
                "scalesProperties.textColor": "#999999"
            }
        });
    }

    // Convert our timeframe format to TradingView format
    function getTradeViewInterval(timeframe) {
        const map = {
            '1': '1',
            '5': '5',
            '15': '15',
            '30': '30',
            '60': '60',
            '240': '240',
            '1D': '1D'
        };
        return map[timeframe] || '1';
    }

    // Handle timeframe change
    function changeTimeframe(timeframe) {
        // Update button styles
        document.querySelectorAll('.timeframe-btn').forEach(btn => {
            btn.classList.remove('bg-theme-primary/10', 'text-theme-primary');
            btn.classList.add('text-gray-400', 'hover:text-white');

            if (btn.dataset.timeframe === timeframe) {
                btn.classList.remove('text-gray-400', 'hover:text-white');
                btn.classList.add('bg-theme-primary/10', 'text-theme-primary');
            }
        });

        // Update chart
        initTradingView(timeframe);
    }

    // Add to your event handlers
    function handleTimeframeChange(newTimeframe) {
        state.timeframe = newTimeframe;
        changeTimeframe(newTimeframe);
        updateKlineSubscription(); // Update WebSocket subscription on timeframe change
    }

    // Update the WebSocket subscription when timeframe changes
    function updateKlineSubscription() {
        if (state.ws && state.ws.readyState === WebSocket.OPEN) {
            const unsub = {
                "unsub": `market.${state.symbol.toLowerCase()}.kline.${state.timeframe}`
            };
            state.ws.send(JSON.stringify(unsub));

            const sub = {
                "sub": `market.${state.symbol.toLowerCase()}.kline.${state.timeframe}`,
                "id": `${state.symbol.toLowerCase()}_kline_${state.timeframe}`
            };
            state.ws.send(JSON.stringify(sub));
        }
    }

    // Initialize TradingView Chart on page load with default timeframe
    initTradingView(state.timeframe);

    // WebSocket Connection
    function connectWebSocket() {
        if (state.ws) {
            state.ws.close();
        }

        try {
            state.ws = new WebSocket('wss://api.huobi.pro/ws');

            state.ws.onopen = function() {
                console.log('WebSocket Connected');
                state.reconnectAttempts = 0;

                // Subscribe to market ticker
                const tickerSub = {
                    "sub": `market.${state.symbol.toLowerCase()}.ticker`,
                    "id": state.symbol
                };
                state.ws.send(JSON.stringify(tickerSub));

                // Subscribe to kline based on current timeframe
                const klineSub = {
                    "sub": `market.${state.symbol.toLowerCase()}.kline.${state.timeframe}`,
                    "id": `${state.symbol.toLowerCase()}_kline_${state.timeframe}`
                };
                state.ws.send(JSON.stringify(klineSub));
            };

            state.ws.onmessage = function(event) {
                try {
                    const blob = event.data;
                    if (typeof blob === 'string') {
                        handleWebSocketMessage(JSON.parse(blob));
                    } else {
                        // Handle binary message
                        const reader = new FileReader();
                        reader.onload = function() {
                            const data = JSON.parse(pako.inflate(reader.result, { to: 'string' }));
                            handleWebSocketMessage(data);
                        };
                        reader.readAsArrayBuffer(blob);
                    }
                } catch (e) {
                    console.warn('WebSocket message parsing error:', e);
                }
            };

            state.ws.onclose = function() {
                if (state.reconnectAttempts < state.maxReconnectAttempts) {
                    console.log(`WebSocket closed. Attempting to reconnect (${state.reconnectAttempts + 1}/${state.maxReconnectAttempts})`);
                    state.reconnectAttempts++;
                    const delay = Math.min(1000 * Math.pow(2, state.reconnectAttempts), 30000); // Exponential backoff with max 30s
                    setTimeout(connectWebSocket, delay);
                } else {
                    console.error('WebSocket connection failed after maximum attempts');
                    startPricePolling();
                }
            };

            state.ws.onerror = function(error) {
                console.warn('WebSocket error, will attempt to reconnect');
                state.ws.close();
            };

        } catch (error) {
            console.error('WebSocket connection error:', error);
            startPricePolling();
        }
    }

    // Handle WebSocket Messages
    function handleWebSocketMessage(data) {
        if (data.ping) {
            state.ws.send(JSON.stringify({ pong: data.ping }));
            return;
        }

        if (data.tick) {
            updatePriceDisplay(data.tick);
        }

        if (data.ch && data.ch.includes('kline')) {
            updateKlineDisplay(data.tick);
        }
    }

    // Update Price Display
    function updatePriceDisplay(tick) {
        state.currentPrice = tick.close;
        
        elements.currentPrice.textContent = `$${formatNumber(tick.close)}`;
        elements.volume.textContent = formatNumber(tick.vol);
        elements.high.textContent = `$${formatNumber(tick.high)}`;
        elements.low.textContent = `$${formatNumber(tick.low)}`;

        const change = ((tick.close - tick.open) / tick.open) * 100;
        const changeText = `${change >= 0 ? '+' : ''}${change.toFixed(2)}%`;
        elements.priceChange.innerHTML = `<span class="${change >= 0 ? 'text-green-500' : 'text-red-500'}">${changeText}</span>`;

        updatePotentialReturn();
    }

    // Update Kline Display (if needed)
    function updateKlineDisplay(tick) {
        // You can process kline data here if needed
        // For example, updating additional UI elements based on kline data
        // Currently, TradingView widget handles chart updates
    }

    // Polling Fallback
    let pollingInterval;

    function startPricePolling() {
        if (pollingInterval) clearInterval(pollingInterval);
        pollingInterval = setInterval(async () => {
            try {
                const response = await fetch(`/trading/market-data?symbol=${state.symbol.toLowerCase()}`);
                if (response.ok) {
                    const data = await response.json();
                    if (data.success) {
                        updatePriceDisplay(data.data);
                    }
                }
            } catch (error) {
                console.warn('Price polling error:', error);
            }
        }, 3000);
    }

    // Event Handlers
    elements.riseButton.addEventListener('click', () => setTradeType('Rise'));
    elements.fallButton.addEventListener('click', () => setTradeType('Fall'));

    elements.tradeAmount.addEventListener('input', function() {
        state.amount = parseFloat(this.value) || 0;
        validateTrade();
        updatePotentialReturn();
    });

    document.querySelectorAll('.quick-amount').forEach(button => {
        button.addEventListener('click', () => {
            const amount = parseFloat(button.dataset.amount);
            if (!isNaN(amount)) {
                elements.tradeAmount.value = amount;
                state.amount = amount;
                validateTrade();
                updatePotentialReturn();
            }
        });
    });

    document.querySelectorAll('.duration-btn').forEach(button => {
        button.addEventListener('click', () => {
            document.querySelectorAll('.duration-btn').forEach(btn => {
                btn.classList.remove('border-theme-primary', 'text-theme-primary');
            });
            button.classList.add('border-theme-primary', 'text-theme-primary');
            state.duration = button.dataset.duration;
            validateTrade();
        });
    });

    document.getElementById('maxAmount').addEventListener('click', () => {
        const balance = parseFloat(elements.walletBalance.textContent.replace(/[^0-9.-]+/g, ''));
        if (!isNaN(balance)) {
            elements.tradeAmount.value = balance;
            state.amount = balance;
            validateTrade();
            updatePotentialReturn();
        }
    });

    elements.placeTrade.addEventListener('click', placeTrade);

    // Timeframe Buttons Event Listeners
    elements.timeframeButtons.forEach(button => {
        button.addEventListener('click', () => {
            const newTimeframe = button.dataset.timeframe;
            if (newTimeframe && newTimeframe !== state.timeframe) {
                handleTimeframeChange(newTimeframe);
            }
        });
    });

    // Trade Type Selection
    function setTradeType(type) {
        state.tradeType = type;
        
        // Update UI
        elements.riseButton.className = `p-4 rounded-lg text-center transition-all ${
            type === 'Rise' 
                ? 'bg-green-500/10 text-green-500 border-2 border-green-500' 
                : 'bg-theme-tertiary text-gray-400 border-2 border-transparent hover:border-green-500/30'
        }`;
        
        elements.fallButton.className = `p-4 rounded-lg text-center transition-all ${
            type === 'Fall' 
                ? 'bg-red-500/10 text-red-500 border-2 border-red-500' 
                : 'bg-theme-tertiary text-gray-400 border-2 border-transparent hover:border-red-500/30'
        }`;

        validateTrade();
    }

    // Update Potential Return
    function updatePotentialReturn() {
        if (state.amount > 0) {
            const potentialReturn = state.amount * (1 + state.profitPercentage / 100);
            elements.potentialReturn.innerHTML = `Potential Return: <span class="text-white">$${formatNumber(potentialReturn)}</span>`;
        } else {
            elements.potentialReturn.innerHTML = `Potential Return: <span class="text-white">$0.00</span>`;
        }
    }

    // Validate Trade
    function validateTrade() {
        const balance = parseFloat(elements.walletBalance.textContent.replace(/[^0-9.-]+/g, ''));
        const valid = state.tradeType && state.amount > 0 && state.amount <= balance;
        
        elements.placeTrade.disabled = !valid;
        elements.tradeButtonText.textContent = valid ? `Place ${state.tradeType} Trade` : 'Select Trade Type';
        
        if (state.amount > balance) {
            showError('Insufficient balance');
        } else {
            hideError();
        }
    }

    // Place Trade
    async function placeTrade() {
        if (elements.placeTrade.disabled) return;

        try {
            elements.placeTrade.disabled = true;
            elements.tradeButtonText.classList.add('hidden');
            elements.tradeButtonLoader.classList.remove('hidden');

            const csrfToken = document.querySelector('meta[name="csrf-token"]')?.content;
            if (!csrfToken) {
                throw new Error('CSRF token not found');
            }

            const response = await fetch('/user/trading/place-trade', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify({
                    type: state.tradeType,
                    amount: state.amount,
                    duration: state.duration,
                    entry_price: state.currentPrice,
                    pair: state.symbol,
                    profit_percentage: state.profitPercentage
                })
            });

            const data = await response.json();

            if (data.success) {
                showSuccess('Trade placed successfully');
                elements.walletBalance.textContent = `$${formatNumber(data.new_balance)}`;
                elements.tradeAmount.value = '';
                state.amount = 0;
                updatePotentialReturn();
            } else {
                throw new Error(data.message || 'Failed to place trade');
            }

        } catch (error) {
            showError(error.message);
        } finally {
            elements.placeTrade.disabled = false;
            elements.tradeButtonLoader.classList.add('hidden');
            elements.tradeButtonText.classList.remove('hidden');
            validateTrade();
        }
    }

    // Error Handling
    function showError(message) {
        elements.amountError.textContent = message;
        elements.amountError.classList.remove('hidden');
    }

    function hideError() {
        elements.amountError.classList.add('hidden');
    }

    // Success Message
    function showSuccess(message) {
    // Using SweetAlert2 for success messages
    Swal.fire({
        title: 'Success',
        text: message,
        icon: 'success',
        background: 'var(--color-background-tertiary)',
        color: 'white', // Added this line to set message color to white
        confirmButtonColor: 'var(--color-primary)',
        timer: 3000,
        timerProgressBar: true
    }).then((result) => {
        if (result.isConfirmed) {
            location.reload();
        }
    });
    }

    // Utility Functions
    function formatNumber(num) {
        if (isNaN(num)) return '0.00';
        return new Intl.NumberFormat('en-US', {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        }).format(num);
    }


    // Initialize WebSocket Connection
    connectWebSocket();

    // Cleanup on page unload
    window.addEventListener('beforeunload', () => {
        if (state.ws) state.ws.close();
        if (pollingInterval) clearInterval(pollingInterval);
    });
});
</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.millage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sbrbot/6figs.sbrbot.trading/resources/views/millage/trading-page/trade.blade.php ENDPATH**/ ?>