<div id="chat-widget" class="fixed md:bottom-4 bottom-20 right-4 z-[999]">
    <!-- Pusher Script -->
    <script src="https://js.pusher.com/8.0/pusher.min.js"></script>
    <script>
        const pusher = new Pusher('<?php echo e(config('broadcasting.connections.pusher.key')); ?>', {
            cluster: '<?php echo e(config('broadcasting.connections.pusher.options.cluster')); ?>',
            encrypted: true
        });

        const channel = pusher.subscribe('chat');
        
       channel.bind('NewMessage', function(data) {
    console.log('New message received:', data);
    
    // Check if the message is for current user
    if (data.message.to_user == <?php echo e(auth()->id()); ?>) {
        // Check if chat window is open
        const chatWindow = document.getElementById('chat-window');
        if (!chatWindow.classList.contains('hidden')) {
            // If chat is open, just load new messages and mark as read
            loadMessages();
            fetch('/chat/mark-read', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            });
        } else {
            // Only update unread count if chat window is closed
            updateUnreadCount();
        }
    }
});
    </script>
    <!-- Modal -->
<div id="end-chat-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center">
    <div class="bg-gray-800 p-6 rounded-lg max-w-sm mx-4">
        <h3 class="text-white font-semibold text-lg mb-4">End Chat</h3>
        <p class="text-gray-300 mb-6">Are you sure you want to end this chat? All messages and files will be permanently deleted.</p>
        <div class="flex justify-end space-x-3">
            <button onclick="hideEndChatModal()" 
                    class="px-4 py-2 text-gray-300 hover:text-white">
                Cancel
            </button>
            <button onclick="executeEndChat()" 
                    class="px-4 py-2 bg-red-500 hover:bg-red-600 text-white rounded">
                End Chat
            </button>
        </div>
    </div>
</div>

    <!-- Chat Icon -->
    <button onclick="toggleChat()" 
            class="w-14 h-14 bg-blue-600 hover:bg-blue-700 text-white rounded-full shadow-lg flex items-center justify-center relative transition-all duration-200">
        <i class="fas fa-comment-dots text-xl"></i>
        <span id="unread-badge" 
              class="hidden absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center">
            0
        </span>
    </button>

    <!-- Chat Window -->
    <div id="chat-window" class="hidden absolute bottom-20 right-0 w-96 bg-gray-900 rounded-lg shadow-xl overflow-hidden border border-gray-700">
        <!-- Header -->
        <div class="bg-gray-800 text-white p-4">
            <div class="flex justify-between items-center">
                <div class="font-semibold flex items-center">
                    <i class="fas fa-headset mr-2"></i> Support Chat
                </div>
     <div class="flex items-center space-x-2">
            <!-- End Chat Button -->
            <button id="end-chat-btn" 
                    onclick="confirmEndChat()" 
                    class="hidden text-red-400 hover:text-red-300 px-2 py-1 text-sm">
                <i class="fas fa-times-circle mr-1"></i>
                End Chat
            </button>
                <button onclick="toggleChat()" class="text-gray-400 hover:text-white">
                    <i class="fas fa-times"></i>
                </button>
    </div>
            </div>
        </div>

        <div class="h-[400px] flex flex-col">
            <!-- Messages List -->
            <div id="messages-list" class="flex-1 overflow-y-auto p-4 space-y-4 bg-gray-900">
                <!-- Messages will be loaded here -->
            </div>

            <div class="p-4 border-t border-gray-700 bg-gray-800">
    <div id="typing-indicator" class="text-xs text-gray-400 mb-2 hidden">
        Admin is typing...
    </div>
     <div class="flex flex-col space-y-2">
        <!-- File Preview Area -->
        <div id="file-preview" class="hidden rounded-lg bg-gray-700 p-2 mb-2">
            <div class="flex items-center justify-between">
                <span id="file-name" class="text-sm text-gray-300 truncate"></span>
                <button onclick="removeFile()" class="text-gray-400 hover:text-white">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <div class="flex space-x-2">
            <label class="cursor-pointer">
                <input type="file" 
                       id="file-input" 
                       class="hidden" 
                       accept="image/*,.pdf,.doc,.docx">
                <div class="w-10 h-10 bg-gray-700 hover:bg-gray-600 rounded-full flex items-center justify-center text-gray-300 hover:text-white">
                    <i class="fas fa-paperclip"></i>
                </div>
            </label>
            <input type="text" 
                   id="message-input"
                   class="flex-1 bg-gray-700 border border-gray-600 rounded-full px-4 py-2 text-sm text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500"
                   placeholder="Type your message...">
            <button onclick="sendMessage()"
                    class="bg-blue-600 hover:bg-blue-700 text-white rounded-full p-2 w-10 h-10 flex items-center justify-center transition-colors duration-200">
                <i class="fas fa-paper-plane"></i>
            </button>
        </div>
    </div>
</div>
        </div>
    </div>
</div>

<script>
let messageRefreshInterval;

function confirmEndChat() {
    if (confirm('Are you sure you want to end this chat? All messages will be deleted permanently.')) {
        endChat();
    }
}

function endChat() {
    fetch('/chat/end', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Hide end chat button
            document.getElementById('end-chat-btn').classList.add('hidden');
            
            // Clear messages
            const messagesList = document.getElementById('messages-list');
            messagesList.innerHTML = `
                <div class="flex justify-center items-center h-full">
                    <div class="text-gray-400 text-center">
                        <p>Chat ended. All messages have been deleted.</p>
                        <p class="text-sm mt-2">You can start a new conversation anytime.</p>
                    </div>
                </div>
            `;
            // Reset unread count
            updateUnreadCount();
        }
    })
    .catch(error => console.error('Error:', error));
}

function toggleChat() {
    const chatWindow = document.getElementById('chat-window');
    chatWindow.classList.toggle('hidden');
    
    if (!chatWindow.classList.contains('hidden')) {
        loadMessages();
        // Start auto-refresh when chat is opened
        messageRefreshInterval = setInterval(loadMessages, 3000);
        
        fetch('/chat/mark-read', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            }
        }).then(() => {
            updateUnreadCount();
        });
    } else {
        // Clear auto-refresh when chat is closed
        clearInterval(messageRefreshInterval);
    }
}

function loadMessages() {
    fetch('/chat/messages')
        .then(response => response.json())
        .then(messages => {
            const messagesList = document.getElementById('messages-list');
        // Show/hide end chat button based on message count
            const endChatBtn = document.getElementById('end-chat-btn');
            if (messages.length > 0) {
                endChatBtn.classList.remove('hidden');
            } else {
                endChatBtn.classList.add('hidden');
            }
            messagesList.innerHTML = messages.map(message => {
                const isAdminMessage = message.from_user_is_admin;
                let content = `<div class="text-sm">${message.message || ''}</div>`;
                
                // Add file content if present
                if (message.file_url) {
                    if (message.file_type?.startsWith('image/')) {
                        content += `
                            <div class="mt-2">
                                <img src="${message.file_url}" class="max-w-[200px] rounded-lg" alt="Attached image">
                            </div>
                        `;
                    } else {
                        content += `
                            <div class="mt-2">
                                <a href="${message.file_url}" 
                                   class="text-blue-400 hover:text-blue-300 flex items-center space-x-2"
                                   target="_blank">
                                    <i class="fas fa-file"></i>
                                    <span>${message.file_name}</span>
                                </a>
                            </div>
                        `;
                    }
                }

                return `
                    <div class="flex ${isAdminMessage ? 'justify-start' : 'justify-end'}">
                        <div class="${isAdminMessage 
                            ? 'bg-gray-700 text-white rounded-bl-none' 
                            : 'bg-blue-600 text-white rounded-br-none'} 
                            rounded-2xl px-4 py-2 max-w-[75%]">
                            ${content}
                            <div class="text-xs ${isAdminMessage 
                                ? 'text-gray-400' 
                                : 'text-blue-200'} mt-1">
                                ${new Date(message.created_at).toLocaleTimeString([], { 
                                    hour: '2-digit', 
                                    minute: '2-digit',
                                    hour12: true 
                                })}
                            </div>
                        </div>
                    </div>
                `;
            }).join('');
            messagesList.scrollTop = messagesList.scrollHeight;
        });
}


function updateUnreadCount() {
    fetch('/chat/unread-count')
        .then(response => response.json())
        .then(data => {
            const badge = document.getElementById('unread-badge');
            if (data.count > 0) {
                badge.textContent = data.count > 99 ? '99+' : data.count;
                badge.classList.remove('hidden');
            } else {
                badge.classList.add('hidden');
            }
        });
}


let selectedFile = null;
let typingTimeout = null;

// File handling
document.getElementById('file-input').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        selectedFile = file;
        const preview = document.getElementById('file-preview');
        const fileName = document.getElementById('file-name');
        fileName.textContent = file.name;
        preview.classList.remove('hidden');
    }
});

function removeFile() {
    selectedFile = null;
    document.getElementById('file-input').value = '';
    document.getElementById('file-preview').classList.add('hidden');
}

function sendMessage() {
    const input = document.getElementById('message-input');
    const message = input.value.trim();
    
    // Allow sending if there's either a message or a file
    if (!message && !selectedFile) return;
    
    const formData = new FormData();
    if (message) formData.append('message', message);
    if (selectedFile) formData.append('file', selectedFile);

    fetch('/chat/send', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: formData
    })
    .then(response => response.json())
    .then(() => {
        input.value = '';
        removeFile();
        loadMessages();
    })
    .catch(error => console.error('Error:', error));
}

function showEndChatModal() {
    document.getElementById('end-chat-modal').classList.remove('hidden');
}

function hideEndChatModal() {
    document.getElementById('end-chat-modal').classList.add('hidden');
}

function confirmEndChat() {
    showEndChatModal();
}

function executeEndChat() {
    hideEndChatModal();
    endChat();
}

// Add listener for admin typing event
channel.bind('typing', function(data) {
    if (data.user_id != <?php echo e(auth()->id()); ?>) {
        const typingIndicator = document.getElementById('typing-indicator');
        typingIndicator.classList.remove('hidden');
        
        // Hide the indicator after 2 seconds
        if (typingTimeout) clearTimeout(typingTimeout);
        typingTimeout = setTimeout(() => {
            typingIndicator.classList.add('hidden');
        }, 2000);
    }
});

// Typing indicator
document.getElementById('message-input').addEventListener('input', function() {
    // Emit typing event to Pusher
    fetch('/chat/typing', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    });
});

// Handle Enter key
document.getElementById('message-input').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        sendMessage();
    }
});

// Update unread count every 30 seconds
setInterval(updateUnreadCount, 10000);

// Initial load
document.addEventListener('DOMContentLoaded', function() {
    updateUnreadCount();
});
</script>




<?php /**PATH C:\xampp\htdocs\6figstrade\resources\views/layouts/includes/chat/widget.blade.php ENDPATH**/ ?>