<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" x-data="{
    nav_open: false
}" x-bind:class="nav_open ? 'nav_open' : ''">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e($settings->site_name); ?> | <?php echo e($title ?? ''); ?></title>
    <link rel="icon" href="<?php echo e(asset($settings->favicon)); ?>" type="image/png" />
    
    
    <?php if (isset($component)) { $__componentOriginal0da7fdd230d9910d3b064fc625b672b8 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0da7fdd230d9910d3b064fc625b672b8 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.theme-colors','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('theme-colors'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0da7fdd230d9910d3b064fc625b672b8)): ?>
<?php $attributes = $__attributesOriginal0da7fdd230d9910d3b064fc625b672b8; ?>
<?php unset($__attributesOriginal0da7fdd230d9910d3b064fc625b672b8); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0da7fdd230d9910d3b064fc625b672b8)): ?>
<?php $component = $__componentOriginal0da7fdd230d9910d3b064fc625b672b8; ?>
<?php unset($__componentOriginal0da7fdd230d9910d3b064fc625b672b8); ?>
<?php endif; ?>
    
    <!-- Fonts and icons -->
    <script src="<?php echo e(asset('dash/js/plugin/webfont/webfont.min.js')); ?>"></script>
    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset('dash/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('dash/css/fonts.min.css')); ?>">
    <?php echo $__env->make('layouts.includes.color', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link rel="stylesheet" href="<?php echo e(asset('dash/css/style.css')); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
    <?php echo e($styles ?? ''); ?>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <style>
        .modal-content[data-background-color="dark"] {
            background-color: #1a2035;
        }

        body[data-background-color="dark"] .table-hover {
            color: #f0f0f0 important;
        }
    </style>
</head>

<body data-background-color="light">
    <div class="wrapper">
        <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if(auth()->guard()->check()): ?>
    <?php if(auth()->user()->is_admin): ?>
        <?php echo $__env->make('layouts.includes.chat.admin-widget', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php endif; ?>
        <script>
            function setTheme() {
                const savedMode = localStorage.getItem('background-color');
                const darkIcon = document.querySelector('.dark-icon');
                const lightIcon = document.querySelector('.light-icon');
                const modal = document.querySelector('.modal-content');
                // get all element with class of .bg-light
                const lightbg = document.querySelectorAll('.bg-light');
                const transbg = document.querySelectorAll('.bg-drk-trans');
                if (savedMode) {
                    if (savedMode === 'dark') {
                        darkIcon.classList.remove('d-none');
                        lightIcon.classList.add('d-none');
                        if (lightbg) {
                            lightbg.forEach(element => {
                                element.classList.remove('bg-light');
                            });
                        }
                    } else {
                        lightIcon.classList.remove('d-none');
                        darkIcon.classList.add('d-none');
                        if (transbg) {
                            transbg.forEach(element => {
                                element.classList.add('bg-light');
                            });
                        }
                    }
                    document.body.setAttribute('data-background-color', savedMode);
                    document.querySelector('.sidebar-style-2').setAttribute('data-background-color', savedMode);
                    if (modal) {
                        modal.setAttribute('data-background-color', savedMode);
                    }
                }
            }
            setTheme();
        </script>
        <div class="main-panel">
            <div class="content">
                <div class="page-inner">
                    <?php echo e($slot); ?>

                </div>
            </div>
            <footer class="footer">
                <div class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                    'text-center' => !$settings->enable_google_translate,
                    'd-flex justify-content-between align-items-center' =>
                        $settings->enable_google_translate,
                ]); ?>">
                    <p>All Rights Reserved &copy; <?php echo e($settings->site_name); ?> <?php echo e(date('Y')); ?></p> <br>
                    <?php if($settings->enable_google_translate): ?>
                        <div class="text-center">
                            <div id="google_translate_element"></div>
                        </div>
                    <?php endif; ?>
                </div>
            </footer>
        </div>
        <script>
            function setTheme() {
                const savedMode = localStorage.getItem('background-color');
                const darkIcon = document.querySelector('.dark-icon');
                const lightIcon = document.querySelector('.light-icon');
                const modal = document.querySelector('.modal-content');
                // get all element with class of .bg-light
                const lightbg = document.querySelectorAll('.bg-light');
                const transbg = document.querySelectorAll('.bg-drk-trans');
                if (savedMode) {
                    if (savedMode === 'dark') {
                        darkIcon.classList.remove('d-none');
                        lightIcon.classList.add('d-none');
                        if (lightbg) {
                            lightbg.forEach(element => {
                                element.classList.remove('bg-light');
                            });
                        }
                    } else {
                        lightIcon.classList.remove('d-none');
                        darkIcon.classList.add('d-none');
                        if (transbg) {
                            transbg.forEach(element => {
                                element.classList.add('bg-light');
                            });
                        }
                    }
                    document.body.setAttribute('data-background-color', savedMode);
                    document.querySelector('.sidebar-style-2').setAttribute('data-background-color', savedMode);
                    if (modal) {
                        modal.setAttribute('data-background-color', savedMode);
                    }
                }
            }
            setTheme();
        </script>
    </div>


    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"
        <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>></script>
    <script src="<?php echo e(asset('dash/js/core/popper.min.js')); ?>" <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>>
    </script>
    <script src="<?php echo e(asset('dash/js/core/bootstrap.min.js')); ?> "
        <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>></script>
    <script type="text/javascript" src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit">
    </script>
    <!-- jQuery UI -->
    <script src="<?php echo e(asset('dash/js/plugin/jquery-ui-1.12.1.custom/jquery-ui.min.js')); ?>"
        <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>></script>
    <script src="<?php echo e(asset('dash/js/plugin/jquery-ui-touch-punch/jquery.ui.touch-punch.min.js')); ?>"
        <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>></script>
    <!-- jQuery Scrollbar -->
    <script src="<?php echo e(asset('dash/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js')); ?> "
        <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>></script>
    <script src="<?php echo e(asset('dash/js/customs.js')); ?>" <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>></script>
    <script src="//cdn.ckeditor.com/4.16.2/standard/ckeditor.js"
        <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"
        <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>></script>
    <script src="<?php echo e(asset('dash/js/core/index.js')); ?>"></script>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo e($scripts ?? ''); ?>

    <script src="<?php echo e(asset('dash/js/plugin/sweetalert/sweetalert2.all.min.js')); ?>"
        <?php if($settings->spa_mode): ?> data-navigate-once <?php endif; ?>></script>
    <?php if (isset($component)) { $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'livewire-alert::components.scripts','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('livewire-alert::scripts'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $attributes = $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $component = $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
    <script>
        document.addEventListener('livewire:navigated', () => {
            $("html").removeClass("nav_open")
        })
    </script>
    <script>
        window.addEventListener('reload-page', () => {
    window.location.reload();
});
    </script>
</body>

</html>





<?php /**PATH /home/sbrbot/6figs.sbrbot.trading/resources/views/layouts/admin.blade.php ENDPATH**/ ?>