<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <script type="text/javascript" src="https://js.stripe.com/v3/"></script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="locale" content="<?php echo e(app()->getLocale()); ?>">
    <meta name="content-language" content="<?php echo e(app()->getLocale()); ?>">
    <title><?php echo e($settings->site_name); ?> | <?php echo e($title ?? ''); ?><?php echo $__env->yieldContent('title'); ?></title>
    <link rel="icon" href="<?php echo e(asset($settings->favicon)); ?>" type="image/png" />
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    
    <?php if (isset($component)) { $__componentOriginal0da7fdd230d9910d3b064fc625b672b8 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0da7fdd230d9910d3b064fc625b672b8 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.theme-colors','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('theme-colors'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0da7fdd230d9910d3b064fc625b672b8)): ?>
<?php $attributes = $__attributesOriginal0da7fdd230d9910d3b064fc625b672b8; ?>
<?php unset($__attributesOriginal0da7fdd230d9910d3b064fc625b672b8); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0da7fdd230d9910d3b064fc625b672b8)): ?>
<?php $component = $__componentOriginal0da7fdd230d9910d3b064fc625b672b8; ?>
<?php unset($__componentOriginal0da7fdd230d9910d3b064fc625b672b8); ?>
<?php endif; ?>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/dark.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/pako@2.1.0/dist/pako.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://unpkg.com/lucide@latest"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
    <script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap');

        body {
            font-family: 'Inter', sans-serif;
        }

        /* Custom Scrollbar Styling */
        * {
            scrollbar-width: thin;
            /* For Firefox */
            scrollbar-color: var(--color-primary-20) var(--color-tertiary);
            /* Thumb color and track color */
        }

        /* Webkit Browsers (Chrome, Safari, newer versions of Opera) */
        *::-webkit-scrollbar {
            width: 8px;
            /* Thin scrollbar */
        }

        *::-webkit-scrollbar-track {
            background: #1A1428;
            /* Dark background for the track */
            border-radius: 10px;
        }

        *::-webkit-scrollbar-thumb {
            background-color: rgba(47, 230, 222, 0.2);
            /* Teal color with opacity */
            border-radius: 10px;
            border: 2px solid transparent;
            background-clip: content-box;
        }

        *::-webkit-scrollbar-thumb:hover {
            background-color: rgba(47, 230, 222, 0.4);
            /* Slightly more opaque on hover */
        }

        .opacity-0 {
            opacity: 0;
        }

        .opacity-100 {
            opacity: 1;
        }

        .transition-opacity {
            transition-property: opacity;
        }

        .duration-300 {
            transition-duration: 300ms;
        }
    </style>

    <?php echo $__env->make('layouts.includes.livechat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

</head>

<body class="bg-[#0A0714] text-white min-h-screen">
    <?php echo $__env->make('layouts.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="flex">
        <?php echo $__env->make('layouts.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <main class="flex-1 sm:p-4 md:p-6 pb-20 md:pb-6 overflow-hidden">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

    <?php echo $__env->make('layouts.includes.mobile-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.includes.mobile-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            lucide.createIcons();

            window.locale = '<?php echo e(app()->getLocale()); ?>';
            window.translations = <?php echo json_encode(__('investment'), 15, 512) ?>;
        });

        function setupDropdown(triggerId, menuId) {
            const trigger = document.getElementById(triggerId);
            const menu = document.getElementById(menuId);

            if (trigger && menu) {
                trigger.addEventListener('click', (e) => {
                    e.stopPropagation();
                    menu.classList.toggle('hidden');
                });

                document.addEventListener('click', (e) => {
                    if (!menu.contains(e.target)) {
                        menu.classList.add('hidden');
                    }
                });
            }
        }

        setupDropdown('languageDropdown', 'languageMenu');
        setupDropdown('notificationDropdown', 'notificationMenu');
        setupDropdown('userDropdown', 'userMenu');
    </script>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>





<?php /**PATH /home/karamelh/public_html/corepip.karamelscript.com.ng/resources/views/layouts/millage.blade.php ENDPATH**/ ?>